// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_GAL_VERIFICATION_VENDOR_EXTENSION_CALLBACK_ROUTER_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_GAL_VERIFICATION_VENDOR_EXTENSION_CALLBACK_ROUTER_H

#include "common.h"
#include "IGalVerificationVendorExtensionCallbacks.h"
#include "IVendorExtensionCallbacks.h"

/**
 * This class implements the IVendorExtensionCallbacks for GalVerificationVendorExtension.
 * It simply reads the type from the frame and calls callbacks in the given
 * IGalVerificationVendorExtensionCallbacks.
 */
class GalVerificationVendorExtensionCallbackRouter : public IVendorExtensionCallbacks {
public:
    explicit GalVerificationVendorExtensionCallbackRouter(
        const shared_ptr<IGalVerificationVendorExtensionCallbacks>& callbacks)
        : mCallbacks(callbacks) { }

    ~GalVerificationVendorExtensionCallbackRouter() { }

    /**
     * Reads message type from data, calls the appropriate callback in mCallbacks.
     *
     * @param data Pointer to incoming raw data.
     * @param len Length of incoming data.
     * @return result of the called callback.
     */
    int dataAvailable(uint8_t* data, size_t len);
private:
    shared_ptr<IGalVerificationVendorExtensionCallbacks> mCallbacks;
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_GAL_VERIFICATION_VENDOR_EXTENSION_CALLBACK_ROUTER_H
